﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PhaseAnimation : MonoBehaviour
{
    //Events
    public event EventHandler BounceInCompleted; 
    public event EventHandler BounceOutCompleted;

    private void BounceInBegin()
    {
        //Called when bounce in begins and plays the UI SFX
        if (AudioManager.Instance != null && AudioManager.Instance.BounceInAudio != null)
        {
            AudioManager.Instance.PlaySFX(AudioManager.Instance.BounceInAudio);
        }
    }

    private void BounceOutBegin()
    {
        //Called when bounce out begins and plays the UI SFX
        if (AudioManager.Instance != null && AudioManager.Instance.BounceOutAudio != null)
        {
            AudioManager.Instance.PlaySFX(AudioManager.Instance.BounceOutAudio);
        }
    }

    private void BounceInComplete()
    {
        //Called when bounce in completes and sends an event notification to all subscribers
        EventHandler handler = BounceInCompleted;
        if (handler != null)
        {
            handler(this, null);
        }
    }

    private void BounceOutComplete()
    {
        //Called when bounce out completes and sends an event notification to all subscribers
        EventHandler handler = BounceOutCompleted;
        if (handler != null)
        {
            handler(this, null);
        }
    }
}
